<?php
/**
 * Theme functions and definitions.
 * This child theme was generated by Merlin WP.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */

/*
 * If your child theme has more than one .css file (eg. ie.css, style.css, main.css) then
 * you will have to make sure to maintain all of the parent theme dependencies.
 *
 * Make sure you're using the correct handle for loading the parent theme's styles.
 * Failure to use the proper tag will result in a CSS file needlessly being loaded twice.
 * This will usually not affect the site appearance, but it's inefficient and extends your page's loading time.
 *
 * @link https://developer.wordpress.org/themes/advanced-topics/child-themes/
 */
function buddyx_child_enqueue_styles() {
	wp_enqueue_style( 'buddyx-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style(
		'buddyx-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		array( 'buddyx-style' ),
		wp_get_theme()->get( 'Version' )
	);
}

add_action( 'wp_enqueue_scripts', 'buddyx_child_enqueue_styles' );

if ( get_stylesheet() !== get_template() ) {
	add_filter(
		'pre_update_option_theme_mods_' . get_stylesheet(),
		function ( $value, $old_value ) {
			update_option( 'theme_mods_' . get_template(), $value );
			return $old_value; // prevent update to child theme mods.
		},
		10,
		2
	);
	add_filter(
		'pre_option_theme_mods_' . get_stylesheet(),
		function (
			$default_values
		) {
			return get_option( 'theme_mods_' . get_template(), $default_values );
		}
	);
}
