<?php
/**
 * WBcom_Essential_elementor_Templates Templates Core config.
 *
 * Templates core class is responsible for handling templates library.
 *
 * @link       https://wbcomdesigns.com/plugins
 * @since      1.0.0
 *
 * @package    Wbcom_Essential
 * @subpackage Wbcom_Essential/plugins/elementor/templates/classes
 */

namespace WBcomEssentialelementor\Templates\Classes;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // No access of directly access.

if ( ! class_exists( 'WBcom_Essential_elementor_Templates_Core_Config' ) ) {

	/**
	 *  WBcom_Essential_elementor_Templates Templates Core config.
	 *
	 * Templates core class is responsible for handling templates library.
	 *
	 * @since 1.4.7
	 */
	class WBcom_Essential_elementor_Templates_Core_Config {

		/**
		 * Instance of the class
		 *
		 * @access private
		 * @since  1.4.7
		 * @var $instance
		 */
		private static $instance = null;

		/**
		 * Holds config data.
		 *
		 * @access private
		 * @since  1.4.7
		 * @var $config
		 */
		private $config;

		/**
		 * WBcom_Essential_elementor_Templates_Core_Config constructor.
		 *
		 * Sets config data.
		 *
		 * @since  1.4.7
		 * @access public
		 */
		public function __construct() {

			$this->config = array(
				'wbcom_essential_elementor_temps' => __( 'WBCom Essential Elementor Sections', 'wbcom-essential' ),
				'api'                             => array(
					'enabled'   => true,
					'base'      => 'https://demos.wbcomdesigns.com/elementor/',
					'path'      => 'wp-json/wp/v2/wbcom-essential-elementor',
					'id'        => 9,
					'endpoints' => array(
						'templates'  => '/templates/',
						'categories' => '/categories/',
						'template'   => '/template/',
					),
				),
			);

		}

		/**
		 * Get
		 *
		 * Gets a segment of config data.
		 *
		 * @since  1.4.7
		 * @access public
		 *
		 * @param string $key Key.
		 *
		 * @return string|array|false data or false if not set
		 */
		public function get( $key = '' ) {

			return isset( $this->config[ $key ] ) ? $this->config[ $key ] : false;

		}

		/**
		 * Creates and returns an instance of the class.
		 *
		 * @since  1.4.7
		 * @access public
		 *
		 * @return object
		 */
		public static function get_instance() {

			if ( null === self::$instance ) {

				self::$instance = new self();

			}

			return self::$instance;

		}

	}

}
